@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="card border-0 shadow-custom">
				<div class="card-header border-grey">
					<h3 class="card-title">
						{{ __('member.title') }}
					</h3>
				</div>
				<form method="post" action="{{ route('member.store') }}" enctype="multipart/form-data">
					{{ csrf_field() }}
					<div class="card-body">
						<div class="row">
							<div class="col-lg-12">
								<div class="user-image elevation-3 d-none" id="image-preview"></div>
							</div>
						</div>
						<div class="row">
							<div class="col-lg-6">
								<div class="form-group">
									<label for="reg_no">{{ __('member.reg_no') }}</label>
									<input type="text" value="{{ $reg_no }}" class="form-control" name="reg_no"
										id="reg_no" readonly>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="name" class="required">{{ __('member.name') }}</label>
									<input type="text" value="{{ old('name') }}"
										class="form-control @error('name') is-invalid @enderror" name="name" id="name">
									@error('name')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="gender">{{ __('member.gender') }}</label>
									<select class="form-control" name="gender" id="gender">
										<option value="male" {{ old('gender')=='male' ? 'selected' : '' }}>Male</option>
										<option value="female" {{ old('gender')=='female' ? 'selected' : '' }}>Female
										</option>
									</select>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="age">{{ __('member.age') }}</label>
									<input type="text" value="{{ old('age') }}" class="form-control" name="age"
										id="age">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="phone" class="required">{{ __('member.phone') }}</label>
									<input type="text" value="{{ old('phone') }}"
										class="form-control @error('phone') is-invalid @enderror" name="phone"
										id="phone">
									@error('phone')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="address">{{ __('member.address') }}</label>
									<input type="text" value="{{ old('address') }}" class="form-control" name="address"
										id="address">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="height">{{ __('member.height') }}</label>
									<input type="text" value="{{ old('height') }}" class="form-control" name="height"
										id="height">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="weight">{{ __('member.weight') }}</label>
									<input type="text" value="{{ old('weight') }}" class="form-control" name="weight"
										id="weight">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="interested_area">{{ __('member.interested_area') }}</label>
									<input type="text" value="{{ old('interested_area') }}" name="interested_area"
										class="form-control" id="interested_area">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="profile_picture">{{ __('member.profile_picture') }}</label>
									<div class="input-group">
										<div class="custom-file">
											<input name="profile_picture" type="file"
												class="custom-file-input @error('profile_picture') is-invalid @enderror"
												id="profile-picture">
											<label class="custom-file-label" for="profile-picture">{{
												__('member.choose_file') }}</label>
										</div>
									</div>
									@error('profile_picture')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="status">{{ __('member.status') }}</label>
									<select class="form-control" name="status" id="status">
										<option value="active" {{ old('status')=='active' ? 'selected' : '' }}>Active
										</option>
										<option value="disabled" {{ old('status')=='disabled' ? 'selected' : '' }}>
											Disabled</option>
									</select>
								</div>
							</div>
							<div class="col-lg-6 ">
								<div class="form-group">
									<label for="js-membership-type" class="required">{{ __('member.membership')
										}}</label>
									<select
										class="form-control select-membership-type @error('type') is-invalid @enderror"
										name="type" id="js-membership-type">
										@foreach($types as $type)
										<option value="{{ $type->id }}" data-duration="{{ $type->duration }}" {{
											old('type')==$type->id ? 'selected' : '' }}>
											{{ $type->name }}
										</option>
										@endforeach
									</select>
									@error('type')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="js-valid-from" class="required">{{ __('member.membership_valid_from')
										}}</label>
									<div class="input-group date" id="date-valid-from" data-target-input="nearest">
										<input type="text" value="{{ old('valid_from') }}"
											class="form-control datetimepicker-input @error('valid_from') is-invalid @enderror"
											name="valid_from" data-target="#date-valid-from" id="js-valid-from" />
										<div class="input-group-append" data-target="#date-valid-from"
											data-toggle="datetimepicker">
											<div class="input-group-text"><i class="fa fa-calendar"></i></div>
										</div>
									</div>
									@error('valid_from')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="js-valid-to" class="required">{{ __('member.to') }}</label>
									<div class="input-group mb-3">
										<input type="text" value="{{ old('valid_to') }}"
											class="form-control @error('valid_to') is-invalid @enderror" name="valid_to"
											id="js-valid-to" readonly>
										<div class="input-group-append">
											<span class="input-group-text"><i class="fa fa-calendar"></i></span>
										</div>
										@error('valid_to')
										<span class="d-block invalid-feedback">{{ $message }}</span>
										@enderror
									</div>
								</div>
							</div>
							<div class="col-lg-6">
								<button type="submit" class="btn btn-primary mt-1">{{ __('member.save_member')
									}}</button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection
@section('js-script')
<!-- PAGE SPECIFIC CUSTOM SCRIPT -->
<script>
	$(function () {
		"use strict";
		// INITIALIZE SELECT2 ELEMENT
		$('.select-membership-type').select2({
			theme: 'bootstrap4'
		})

		// INITIALIZE THE DATE PICKER
		$('#date-valid-from').datetimepicker({
			format: 'YYYY-MM-DD'
		});

		// CALCULATE THE MEMBERSHIP VALID TO DATE
		$('#js-membership-type, #js-valid-from').on('change input', function () {
			var membershipId = parseInt($('#js-membership-type option:selected').val());
			var membershipDuration = parseInt($('#js-membership-type option:selected').data('duration'));
			var validFromDate = moment($('#js-valid-from').val(), 'YYYY-MM-DD');

			if (validFromDate.isValid() && !isNaN(membershipDuration)) {
				var validToDate = validFromDate.clone().add(membershipDuration, 'days');
				$('#js-valid-to').val(validToDate.format('YYYY-MM-DD'));
			}
		});

		// EVENT LISTENER TO PREVIEW PROFILE IMAGE
		$('.custom-file-input').on('change', function () {
			if (this.files && this.files[0]) {
				var file = this.files[0];
				var reader = new FileReader();

				reader.onload = function (e) {
					$('#image-preview').css('background-image', 'url(' + e.target.result + ')');
					$('#image-preview').removeClass('d-none');
					$('#image-preview').addClass('mb-3');
				};

				reader.readAsDataURL(file);
			} else {
				$('#image-preview').addClass('d-none');
				$('#image-preview').removeClass('mb-3');
			}
		});
	});
</script>
@endsection